/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXIPart.m
//  PXIPart
//
//  last changed by: creysoft

#import "PXIPart.h"


@implementation PXIPart

- (id) initWithFrame:(NSRect)frame ofType:(PXIPartType)type andProperties:(NSDictionary*)properties
{
	[self initWithFrame:frame ofType:type withName:@""];
	[self applyDictionary:properties];
	return self;
}

- (void) applyDictionary:(NSDictionary*)properties
{
	NSString * myKey;
	NSEnumerator * myEnumerator = [properties keyEnumerator];

	NSLog( @"Dictionary Description: %@", properties );
	
	while ( myKey = [myEnumerator nextObject] )
	{
		NSLog( @"Assigning value '%@' for key '%@'", [properties valueForKey:myKey], myKey );
		if ( [myKey caseInsensitiveCompare:@"partName"] == NSOrderedSame )
		{
			[self setPartName:[properties objectForKey:myKey]];
		}
		else if ( [myKey caseInsensitiveCompare:@"partID"] == NSOrderedSame )
		{
			[self setPartID:[(NSString*)[properties objectForKey:myKey] intValue]];
		}
		else if ( [myKey caseInsensitiveCompare:@"partNumber"] == NSOrderedSame )
		{
			[self setPartNumber:[(NSString*)[properties objectForKey:myKey] intValue]];
		}
		else if ( [myKey caseInsensitiveCompare:@"specificNumber"] == NSOrderedSame )
		{
			[self setSpecificNumber:[(NSString*)[properties objectForKey:myKey] intValue]];
		}
		else if ( [myKey caseInsensitiveCompare:@"partType"] == NSOrderedSame )
		{
			[self setPartType:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}
		else if ( [myKey caseInsensitiveCompare:@"partStyle"] == NSOrderedSame )
		{
			[self setPartStyle:[(NSNumber*)[properties objectForKey:myKey] intValue]];
		}
		else if ( [myKey caseInsensitiveCompare:@"content"] == NSOrderedSame )
		{
			[self setContent:[properties objectForKey:myKey]];
		}		
		else if ( [myKey caseInsensitiveCompare:@"hilite"] == NSOrderedSame )
		{
			[self setHilite:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}				
		else if ( [myKey caseInsensitiveCompare:@"autoHilite"] == NSOrderedSame )
		{
			[self setAutoHilite:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}						
		else if ( [myKey caseInsensitiveCompare:@"content"] == NSOrderedSame )
		{
			[self setContent:[properties objectForKey:myKey]];
		}
		else if ( [myKey caseInsensitiveCompare:@"fontName"] == NSOrderedSame )
		{
			[self setFontName:[properties objectForKey:myKey]];
		}
		else if ( [myKey caseInsensitiveCompare:@"titleWidth"] == NSOrderedSame )
		{
			[self setTitleWidth:[(NSString*)[properties objectForKey:myKey] intValue]];
		}								
		else if ( [myKey caseInsensitiveCompare:@"visible"] == NSOrderedSame )
		{
			[self setVisible:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}								
		else if ( [myKey caseInsensitiveCompare:@"enabled"] == NSOrderedSame )
		{
			[self setEnabled:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}								
		else if ( [myKey caseInsensitiveCompare:@"showName"] == NSOrderedSame )
		{
			[self setShowName:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}								
		else if ( [myKey caseInsensitiveCompare:@"lineWrap"] == NSOrderedSame )
		{
			[self setLineWrap:[(NSNumber*)[properties objectForKey:myKey] boolValue]];
		}								
		else if ( [myKey caseInsensitiveCompare:@"textAlign"] == NSOrderedSame )
		{
			[self setTextAlign:[(NSNumber*)[properties objectForKey:myKey] intValue]];
		}								
		else if ( [myKey caseInsensitiveCompare:@"textSize"] == NSOrderedSame )
		{
			[self setTextSize:[(NSString*)[properties objectForKey:myKey] intValue]];
		}								
	}
	
}

- (id)initWithFrame:(NSRect)frame ofType:(BOOL)newpartType withName:(NSString*)newpartName
{	
	partType = newpartType;
	if ( newpartType )
	{
		fieldView = [[PXIFieldView alloc] initWithFrame:frame];
		[self setPartName:newpartName];
	}
	else
	{
		buttonView = [[PXIButtonView alloc] initWithFrame:frame];
		//[buttonView setPartName:newpartName];
		[self setPartName:newpartName];
	}
	
	return self;
}

- (int)partID {
    return partID;
}

- (void)setPartID:(int)newPartID {
    if (partID != newPartID) {
        partID = newPartID;
    }
}

- (int)partNumber {
    return partNumber;
}

- (void)setPartNumber:(int)newPartnumber {
    if (partNumber != newPartnumber) {
        partNumber = newPartnumber;
    }
}

- (int)specificNumber {
    return specificNumber;
}

- (void)setSpecificNumber:(int)newSpecificnumber {
    if (specificNumber != newSpecificnumber) {
        specificNumber = newSpecificnumber;
    }
}

- (BOOL)partType {
    return partType;
}

- (void)setPartType:(BOOL)newParttype {
    if (partType != newParttype) {
        partType = newParttype;
    }
}

- (NSString *)partName {
    //return [[partName retain] autorelease];
	if ( [self partType] )
	{
		return [[self fieldView] partName];
	}
	else
	{
		return [[self buttonView] partName];
	}
}

- (void)setPartName:(NSString *)newPartname {
	if ( [self partType] )
	{
		[[self fieldView] setPartName:newPartname];
	}
	else
	{
		[[self buttonView] setPartName:newPartname];
	}
}

- (BOOL)autoHilite
{
	{
		if ( [self partType] == PXIPartTypeButton )
		{
			return [[self buttonView] autoHilite];
		}
		else
		{
			; // Inapplicable
		}
	}
}

- (void)setAutoHilite:(BOOL)newAutohilite
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setAutoHilite:newAutohilite];
	}
	else
	{
		; // Inapplicable
	}
}

- (NSString *)fontName
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] fontName];
	}
	else
	{
		; // Incomplete
	}
}

- (void)setFontName:(NSString *)newFontname
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setFontName:newFontname];
	}
	else
	{
		[[self fieldView] setFont:[NSFont fontWithName:newFontname size:[self textSize]]];
	}	
}

- (int)titleWidth
{
	if ( [self partType] == PXIPartTypeButton )
	{
			return [[self buttonView] titleWidth];
	}
	else
	{
		; // Inapplicable
	}
}

- (void)setTitleWidth:(int)newTitlewidth
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setTitleWidth:newTitlewidth];
	}
	else
	{
		; // Inapplicable
	}
}

- (int)partStyle
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] partStyle];
	}
	else
	{
		return [[self fieldView] partStyle];
	}
}

- (void)setPartStyle:(int)newPartstyle
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setPartStyle:newPartstyle];
	}
	else
	{
		[[self fieldView] setPartStyle:newPartstyle];
	}	
}

- (BOOL)visible
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] visible];
	}
	else
	{
		return YES; // Incomplete
	}
}

- (void)setVisible:(BOOL)newVisible
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setVisible:newVisible];
	}
	else
	{
		; // Incomplete
	}
}

- (BOOL)enabled
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] enabled];
	}
	else
	{
		return YES; // Incomplete
	}
}

- (void)setEnabled:(BOOL)newEnabled
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setEnabled:newEnabled];
	}
	else
	{
		; // Incomplete
	}
}

- (BOOL)hilite
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] hilite];
	}
	else
	{
		return NO; // Incomplete
	}
}

- (void)setHilite:(BOOL)newHilite
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setHilite:newHilite];
	}
	else
	{
		; // Incomplete
	}
}

- (BOOL)showName
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] showName];
	}
	else
	{
		return NO; // Incomplete
	}
}

- (void)setShowName:(BOOL)newShowname
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setShowName:newShowname];
	}
	else
	{
		; // Incomplete
	}
}

- (int)textAlign
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] textAlign];
	}
	else
	{
		return 0; // Incomplete
	}
}

- (void)setTextAlign:(int)newTextalign
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setTextAlign:newTextalign];
	}
	else
	{
		; // Incomplete
	}
}

- (int)textSize
{
	if ( [self partType] == PXIPartTypeButton )
	{
		return [[self buttonView] textSize];
	}
	else
	{
		return 0; // Incomplete
	}
}

- (void)setTextSize:(int)newTextsize
{
	if ( [self partType] == PXIPartTypeButton )
	{
		[[self buttonView] setTextSize:newTextsize];
	}
	else
	{
		[[self fieldView] setTextSize:newTextsize];
	}
}

- (NSString *)content {
	if ( [self partType] == PXIPartTypeField )
	{
		return [[self fieldView] value];
	}
	else
	{
		return [[content retain] autorelease];
	}
}

- (void)setContent:(NSString *)newContent {
    if (content != newContent) {
        [content release];
        content = [newContent copy];
		
		if ( [self partType] == PXIPartTypeField )
		{
			[[self fieldView] setValue:content];
		}
		
    }
}

- (PXIButtonView*)buttonView
{
	return buttonView;
}

- (PXIFieldView*)fieldView
{
	return fieldView;
}

- (NSView*)currentview
{
	if ( partType )
	{
		return fieldView;
	}
	else
	{
		return buttonView;
	}
}

- (BOOL)lineWrap
{
	if ( [self partType] == PXIPartTypeButton )
	{
		; // Inapplicable
	}
	else
	{
		return [[self fieldView] lineWrap];
	}
}
- (void)setLineWrap:(BOOL)newLinewrap
{
	if ( [self partType] == PXIPartTypeButton )
	{
		; // Inapplicable
	}
	else
	{
		[[self fieldView] setLineWrap:newLinewrap];
	}	
}

@end
